import java.sql.SQLException;
import java.time.LocalDate;

public class Main {
    public static void main(String[] args) {
        try (var connection = SQLServerConnection.connect()) {
            //
            var bookDB = new BookDB(connection);

            var fromDate = LocalDate.of(2021,1,1);
            var toDate = LocalDate.of(2022,12,31);

            var books = bookDB.findByPublishedDate(fromDate, toDate );

            for (var book: books) {
                System.out.println(book.getTitle()  + '\t' + book.getPublishedDate());
            }
        } catch (SQLException | DBException e) {
            System.err.println(e.getMessage());
        }
    }
}